
/**
 ******************************************************************************
 *
 * @file        Keil_WizardExample.h
 * @brief       Keil Wizard Example
 *
 * @par         Project
 *              MG32
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
/* Wizard menu ---------------------------------------------------------------*/
//*** <<< Use Configuration Wizard in Context Menu >>> ***
// <h> Test h
//   <o0> Test0 all
//   <o1.0> Test1 Bit 0
//   <o1.3> Test1 Bit 3
//   <o1.8..11> Test1 Bit 8 to 11
//   <o2.4..7> Test2 Number1 Bit 4 to 7
//   <o4> Test3 <0=>Select0 <1=>Select1 <5=>Select5 <100=>Select 100(0x64) 
//              <0x66=>Select 0x66  <110=>Select110(0x6E)
//     <i>Test3 Note
//   <o3> Test2 Number 2 <10-100>
//     <i>Test2 Note
// </h>

// <e5> Test5 Bit0
//   <e8> Test8 Bit0
//     <o9.2> Test9 Bit1
//     <o9.2> Test9 Bit2
//   </e>
//   <q6> Test6
//   <o7.2> Test7 Bit1
//   <o7.2> Test7 Bit2
// </e>
// <o10.2> Test10 Bit1
// <o10.2> Test10 Bit2
//
// <s0> Test15 String0
// <s1.30> Test16 String1

#ifndef __COMMON_H
#define __COMMON_H

#define Test0 5
#define Test1 0x0A08
#define Test2 0x00000AA1 * 100
#define Test3 0x0000006E

#define Test5 0x00000000
#define Test6 0x00000001
#define Test7 0x00000000
#define Test8 0x00000000
#define Test9 0x00000000

#define Test10 0x00000001
#define Test11 0x00000000
#define Test12 0x00000000
#define Test13 0x00000000
#define Test14 0x00000000

#define Test15 "Test15_String0_YYYY"
#define Test16 "Test16_String1_xxxx"


#include "config.h"



#endif  /* __COMMON_H */

//*** <<< end of configuration section >>>    ***

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/



